###############################################################################
# CardFormѥǡץ饰Υ١饹Ǥ
###############################################################################
package plugin::cardform::CardFuncBase;
use strict;
#==============================================================================
# <p>
#   %cacheϻѤڡͤ򥭥å夹뤿ŪѿǤ
# </p>
# <dl>
#   <dt>{$base}{regex}</dt>
#     <dd>å夹٤٥˴ؤϥåѿ</dd>
#   <dt>{$base}{init}</dt>
#     <dd>Form*ǻѤͤ˴ؤϥåѿ</dd>
#   <dt>{$base}{$number}</dt>
#     <dd>ƥڡֹΥ٥Фͤ򥭥å夹ϥåѿ</dd>
# </dl>
# <p>
#   %initϽͼѥڡƤ򥭥å夹뤿ŪѿǤ
# </p>
# <dl>
#   <dt>{basename}</dt>
#     <dd>¸ƤǡΥ١͡</dd>
#   <dt>{basecache}</dt>
#     <dd>baseڡΥå</dd>
#   <dt>{pagename}</dt>
#     <dd>¸Ƥǡڡ̾</dd>
#   <dt>{pagecache}</dt>
#     <dd>ǡڡΥå</dd>
# </dl>
#==============================================================================
use vars qw(%cache %init);
%cache=();
%init=();
#==============================================================================
# <p>
#   ѿ{cache}%cacheΥե󥹤ǽޤ
# </p>
# <p>
#   ѿ{init}%initΥե󥹤ǽޤ
# </p>
#==============================================================================
sub new {
	my $class = shift;
	my $self  = {};
	$self->{cache} = \%plugin::cardform::CardFuncBase::cache;
	$self->{init} = \%plugin::cardform::CardFuncBase::init;
	return bless $self,$class;
}
#==============================================================================
# <p>
#   ١̾ȥڡֹ椫ڡ̾ޤ
# </p>
# <pre>
# ->num2page($base,$number);
# ->num2page($base,@number);
# </pre>
# <ul>
#   <li>$baseϥ١̾Ǥ</li>
#   <li>$number@numberϥڡֹǤ</li>
#   <li>ͤϥڡ̾Ǥ</li>
#   <li>ڡֹ椬ñξ硢ͤϥ顼Ǥ</li>
#   <li>ڡֹ椬ꥹȤξ硢ͤϥꥹȤǤ</li>
#   <li>­ʤ϶ΥꥹȤޤundef֤ޤ</li>
# </ul>
#==============================================================================
sub num2page {
	my $self = shift;
	my $base = shift;
	if(@_>1){
		return map "$base/$_", @_;
	}elsif(@_==1){
		return "$base/".$_[0];
	}else{
		return wantarray ? () : undef;
	}
}
#==============================================================================
# <p>
#   ڡֹꥹȤޤ
#   å夬ʤˤΤ߼ºݤ˥ڡ򸡺ޤ
#   åɽƤѹޤ
# </p>
# <pre>
# ->get_number_list($wiki,$base);
# </pre>
# <ul>
#   <li>$baseоݥڡΥ١̾Ǥ</li>
#   <li>ͤϥȤ줿ڡΥڡֹꥹȤǤ</li>
#   <li>顼ƥȤǤϥ١̾˳ڡ֤ޤ</li>
#   <li>­ʤ϶ΥꥹȤޤundef֤ޤ</li>
# </ul>
#==============================================================================
sub get_number_list {
	my $self = shift;
	my $wiki = shift;
	my $base = shift;
	my @list;

	if($base eq ""){
		return wantarray ? () : undef;
	}

	# ꤵ줿١̾Υå夬ꡢǤΰʳ
	# ä饭å夵Ƥ롣
	if(exists $self->{cache}{$base}){
		@list = grep /^\d+$/, keys %{$self->{cache}{$base}};
	}
	if(@list){
		return wantarray ? sort {$a<=>$b} @list : scalar @list;
	}

	# å夵Ƥʤ١̾оݥڡꥹȥåפ롣
	@list = grep {s|^\Q$base\E/(\d+)$|$1| and $_}
			$wiki->get_page_list({-permit=>'show'});

	# ɽåϼФ٤ͤΥ٥ݻƤꡢѹʤ
	# ͥå夬¸ߤѹʤ
	$self->{cache}{$base} = {
		regex => $self->{cache}{$base}{regex},
		(exists $self->{cache}{$base}{init})?
			(init => $self->{cache}{$base}{init}):(),
	};

	foreach(@list){
		$self->{cache}{$base}{$_} = {};
	}
	return wantarray ? sort {$a<=>$b} @list : scalar @list;
}
#==============================================================================
# <p>
#   ڡ̾ꥹȤޤ
#   get_number_listͤڡ̾Ѵ֤ޤ
# </p>
# <pre>
# ->get_page_list($wiki,$base);
# </pre>
# <ul>
#   <li>$baseоݥڡΥ١̾Ǥ</li>
#   <li>ͤϥڡֹΥڡ̾ꥹȤǤ</li>
#   <li>­ʤ϶ΥꥹȤޤundef֤ޤ
#       </li>
# </ul>
#==============================================================================
sub get_page_list {
	my $self = shift;
	my $wiki = shift;
	my $base = shift;
	if($base eq ""){
		return wantarray ? () : undef;
	}
	return $self->num2page($base,$self->get_number_list($wiki,$base));
}
#==============================================================================
# <p>
#   do_*_cacheǻѤ٥ꤷޤ
# </p>
# <pre>
# ->set_label($wiki,$base,@label);
# </pre>
# <ul>
#   <li>$baseоݥڡΥ١̾Ǥ</li>
#   <li>@labelϻѤ٥ΥꥹȤǤ</li>
#   <li>ͤϤޤ</li>
# </ul>
#==============================================================================
sub set_label {
	my $self = shift;
	my $wiki = shift;
	my $base = shift;
	if($base eq ""){
		return;
	}
	foreach(@_){
		unless(defined $self->{cache}{$base}{regex}{$_}){
			$self->{cache}{$base}{regex}{$_} = undef;
		}
	}
}
#==============================================================================
# <p>
#   ١̾Υåɽå˥åȤƤ٥̾ȡ
#   ١̾Ʊ̾Υڡʥ١ڡˤƤ顢ͤ뤿ɽ
#   ƥåȤޤ
# </p>
# <pre>
# ->do_regex_cache($wiki,$base);
# </pre>
# <ul>
#   <li>$baseоݥڡΥ١̾Ǥ</li>
#   <li>ͤ1򡢰­ʤ0֤ޤ</li>
# </ul>
# <p>
#   ɽˤĤƤdo_page_cache򻲾ȤƤ
# </p>
#==============================================================================
sub do_regex_cache {
	my $self = shift;
	my $wiki = shift;
	my $base = shift;

	if($base eq ""){
		return 0;
	}

	# ޤɽƤʤ٥ΰ롣
	my @label_list = grep {not defined $self->{cache}{$base}{regex}{$_}}
		keys %{$self->{cache}{$base}{regex}};

	foreach my $label (@label_list){
		# ٥κǸ夬ʤ餽ζƽ̤ˡȤ
		# 롣
		if($label =~ /(.+)[ \t]$/){
			# Ƭ٥뤬ꡢθζޤǤ
			# ʬͤȤʤ롣
			$self->{cache}{$base}{regex}{$label}
				= "(?m)^\Q$1\E[ \t]*(.*)\$",
		}
	}

	# ޤɽƤʤ٥ΰˤ롣
	@label_list = grep {not defined $self->{cache}{$base}{regex}{$_}}
		@label_list;

	# ޤƤʤ٥뤬ʤнλ롣
	return 1 unless (@label_list);

	# ɽΤʤ٥뤬ä١ڡ롣
	my $content;
	if($self->{init}{basename} eq $base){
		# initå夬ꤵƤХå夫
		$content = $self->{init}{basecache} || "";
	}elsif(not $wiki->page_exists($base)){
		# ڡʤж
		$content = "";
	}elsif($wiki->can_show($base)){
		# ȸ¤Хڡ
		$content = $wiki->get_page($base);
	}else{
		# ȸ¤ʤɽʸˤƽλ롣
		# ξ硢٥ͤȤundef֤ޤ
		foreach my $label (@label_list){
			$self->{cache}{$base}{regex}{$label} = "";
		}
		return 0;
	}

	# ١ڡǤä::³٥θˡ
	# :::ǻϤޤʬФθ塢Ը:::
	# ΤߤѹͤȤ롣
	if($content eq ""){
		foreach my $label (@label_list){
			$self->{cache}{$base}{regex}{$label} = {
				regex =>
				    "(?m)^::\Q$label\E\\n:::(.*(\\n:::.*)*)\$",
				s1    => "\\n:::",
				s2    => "\n",
			};
		}
		return 1;
	}

	# ١ڡäϤƤ˽ɽ롣
	foreach my $label (@label_list){
		if($content =~
    /(^|[^\n]+\n?)(\%|\{\{form\w+ )\Q$label\E(\%|\b[^}]*\}\})(\n?[^\n]+|$)/s){
			my ($before,$after) = ($1,$4);
			# %٥%ޤ{{form ٥}}˥ޥåԤ
			# ʸȤäɽ롣
			# ʤʸ%%ޤ{{}}Ȥʸ
			# ".*"Ȥɽˤƥޥå롣
$before =
	join(".*",
		map(quotemeta,
			split(/\%[^\%]*\%|\{\{form\w+\b[^}]*\}\}/,
				$before)
		)
	);
$after =
	join(".*",
		map(quotemeta,
			split(/\%[^\%]*\%|\{\{form\w+\b[^}]*\}\}/,
				$after)
		)
	);
			$before ||= '^';
			$after ||= '$';
			$self->{cache}{$base}{regex}{$label}
				= "(?s)$before(.*?)$after";
		}else{
			# ξˤ⤢ƤϤޤʤ硢ʸȤ롣
			# ξ硢٥ͤȤundef֤ޤ
			$self->{cache}{$base}{regex}{$label} = "";
		}
	}
	return 1;
}
#==============================================================================
# <p>
#   ١ֹ̾ǻꤵڡΥåå­ʬɤ߹
#   ꤷޤ
# </p>
# <pre>
# ->do_page_cache($wiki,$base,$num);
# </pre>
# <ul>
#   <li>$baseоݥڡΥ١̾Ǥ</li>
#   <li>$numоݥڡֹǤ</li>
#   <li>ͤʤ­ʤΥڡ¸ߤޤ</li>
# </ul>
#==============================================================================
sub do_page_cache {
	my $self = shift;
	my $wiki = shift;
	my $base = shift;
	my $num  = shift;

	if($base eq "" or $num eq ""){
		return 0;
	}

	if($num eq "init"){
		# $num"init"ǤϽͼѤνǤ롣
		# ͼϢΥϥåѿꤵƤ뤫å롣
		unless($self->{init}{basename} eq $base){
			return 0;
		}
	}elsif($num =~ /\D/){
		# ǤХ顼Ȥ롣
		return 0;
	}elsif(not exists $self->{cache}{$base}{$num}){
		# å夬ʤСޤֹꥹȤ򥭥å夹롣
		$self->get_number_list($wiki,$base);
		# ǤʤСΥڡ¸ߤʤ
		unless(exists $self->{cache}{$base}{$num}){
			return 0;
		}
	}
	my $page = $self->num2page($base,$num);

	# ޤͤƤʤ٥ΰ롣
	my @label_list = grep {not exists $self->{cache}{$base}{$num}{$_}}
		keys %{$self->{cache}{$base}{regex}};

	# ޤͤƤʤ٥뤬ʤнλ롣
	return 1 unless (@label_list);

	foreach my $label (@label_list){
		# ٥бͤ뤿ɽꤵƤʤС
		# 򤪤ʤ
		unless(defined $self->{cache}{$base}{regex}{$label}){
			$self->do_regex_cache($wiki,$base);
			last;
		}
	}

	# å夵ƤʤͤϥڡƤ롣
	my $content;
	if($num eq "init"){
		unless(exists $self->{init}{pagecache}) {
			# ⤷оݥڡå夵ƤʤХ顼
			return 0;
		}
		# initǤinitå夫
		$content = $self->{init}{pagecache};
	}elsif($wiki->page_exists($page) and $wiki->can_show($page)){
		# ڡꡢȤǤФΥڡ
		$content = $wiki->get_page($page);
	}else{
		# ̾оݥڡȤǤʤϤʤǰΤ
		return 0;
	}

	foreach my $label (@label_list){
		my $regex = $self->{cache}{$base}{regex}{$label};
		my $value;
		if($regex eq ""){
			$value = undef;
		}elsif(ref $regex eq "HASH"){
			# ϥåؤΥե󥹤ä硢
			# 줾ΥͤϰʲΤ褦ʰ̣Ǥ롣

			# s1:ΥмФִͤ黻ҤŬѤ
			#    롣λˤִͤоݤȤʤѥȤʤ롣
			my $s1   = $regex->{s1};

			# s2:ִ黻ҤִʸȤʤ롣
			my $s2   = $regex->{s2} || "";

			# regex:ޥå黻ҤɽȤʤ롣ΤȤ$1ͤ
			#       롣
			$regex   = $regex->{regex} || "";

			if($content =~ /$regex/){
				$value = $1;
			}else{
				$value = undef;
			}
			if($value and $s1){
				$value =~ s/$s1/$s2/g;
			}
		}else{
			# ϥåؤΥե󥹤ǤʤС
			# 줬ɽǤ롣λ$1ͤȤʤ롣
			if($content =~ /$regex/){
				$value = $1;
			}else{
				$value = undef;
			}
		}
		$self->{cache}{$base}{$num}{$label} = $value;
	}
	return 1;
}
#==============================================================================
# <p>
#   ١̾Υåå­ʬɤ߹ڡͤ
#   å夷ޤ
# </p>
# <pre>
# ->do_base_cache($wiki,$base);
# </pre>
# <ul>
#   <li>$baseоݥڡΥ١̾Ǥ</li>
#   <li>ͤʤ­ʤͤ¸ߤޤ</li>
# </ul>
#==============================================================================
sub do_base_cache {
	my $self = shift;
	my $wiki = shift;
	my $base = shift;

	if($base eq ""){
		return 0;
	}

	my @list = $self->get_number_list($wiki,$base);
	unless(@list){
		return 0;
	}
	foreach(@list){
		$self->do_page_cache($wiki,$base,$_);
	}
	return 1;
}
#==============================================================================
# <p>
#   ڡλ٥ͤޤ
# </p>
# <pre>
# ->get_data($wiki,$base,$num,$label);
# </pre>
# <ul>
#   <li>$baseоݥڡΥ١̾Ǥ</li>
#   <li>$numоݥڡΥڡֹǤ</li>
#   <li>$labelϼ٥Ǥ</li>
#   <li>ͤϼͤǤ</li>
#   <li>ͤundefʤ­ʤΥ٥¸ߤޤ</li>
# </ul>
#==============================================================================
sub get_data {
	my $self  = shift;
	my $wiki  = shift;
	my $base  = shift;
	my $num   = shift;
	my $label = shift;

	if($base eq "" or $num eq "" or $label eq ""){
		return undef;
	}

	$self->set_label($wiki,$base,$label);
	$self->do_page_cache($wiki,$base,$num);
	return $self->{cache}{$base}{$num}{$label};
}
#==============================================================================
# <p>
#   ٥ڡͤޤ
# </p>
# <pre>
# ->get_datalist($wiki,$base,$label);
# </pre>
# <ul>
#   <li>$baseоݥڡΥ١̾Ǥ</li>
#   <li>$labelϥ٥Ǥ</li>
#   <li>ͤϼͤΥꥹȤǤ</li>
#   <li>ͤΥꥹȤʤ­ʤڡ¸ߤޤ</li>
# </ul>
#==============================================================================
sub get_datalist {
	my $self  = shift;
	my $wiki  = shift;
	my $base  = shift;
	my $label = shift;

	if($base eq "" or $label eq ""){
		return ();
	}

	my @list = $self->get_number_list($wiki,$base);
	unless(@list){
		return ();
	}
	$self->set_label($wiki,$base,$label);
	$self->do_base_cache($wiki,$base);
	return map $self->{cache}{$base}{$_}{$label},@list;
}
#==============================================================================
# <p>
#   ʣλ٥ڡͤޤ
# </p>
# <pre>
# ->get_alldata($wiki,$base,@label);
# </pre>
# <ul>
#   <li>$baseоݥڡΥ١̾Ǥ</li>
#   <li>@labelϥ٥Ǥ</li>
#   <li>ͤͤ¸Ƥ륭åؤΥե󥹤Ǥ</li>
#   <li>ͤundefʤ­ʤͤ¸ߤޤ</li>
# </ul>
#==============================================================================
sub get_alldata {
	my $self  = shift;
	my $wiki  = shift;
	my $base  = shift;

	if($base eq ""){
		return undef;
	}

	$self->set_label($wiki,$base,@_);
	if($self->do_base_cache($wiki,$base)){
		return $self->{cache}{$base};
	}else{
		return undef;
	}
}
#==============================================================================
# <p>
#   ͼѥڡΥǡ򥻥åȤޤ
# </p>
# <pre>
# ->set_initpage($wiki,$base,$page);
# </pre>
# <ul>
#   <li>$baseоݥڡΥ١̾Ǥ</li>
#   <li>$pageͼڡǤ</li>
#   <li>ͤʤ­ʤڡ¸ߤޤ</li>
# </ul>
#==============================================================================
sub set_initpage {
	my $self = shift;
	my $wiki = shift;
	my $base = shift;
	my $page = shift;
	my $content;

	if($base eq "" or $page eq ""){
		return 0;
	}

	if($wiki->page_exists($base)
		and not $wiki->can_show($base)){
		return 0;
	}
	$content = $wiki->get_page($base);
	unless($content){
		return 0;
	}
	$self->{init}{basename} = $base;
	$self->{init}{basecache} = $content;
	if($wiki->page_exists($page)
		and not $wiki->can_show($page)){
		return 0;
	}
	$content = $wiki->get_page($page);
	unless($content){
		return 0;
	}
	$self->{init}{pagename} = $page;
	$self->{init}{pagecache} = $content;
	return 1;
}
#==============================================================================
# <p>
#   ͼѥڡΥǡåȤƤ뤫ǧޤ
# </p>
# <pre>
# ->is_set_initpage();
# </pre>
# <ul>
#   <li>Ϥޤ</li>
#   <li>ͤʤͼѥڡΥǡåȤƤޤ</li>
# </ul>
#==============================================================================
sub is_set_initpage {
	my $self = shift;
	return exists $self->{init}{pagename};
}
#==============================================================================
# <p>
#   ͼѥڡΥǡ򥯥ꥢޤ
# </p>
# <pre>
# ->unset_initpage();
# </pre>
# <ul>
#   <li>Ϥޤ</li>
#   <li>ͤϤޤ</li>
# </ul>
#==============================================================================
sub unset_initpage {
	my $self = shift;
	my $base = $self->{init}{basename};
	delete $self->{cache}{$base}{init}
		if(exists $self->{cache}{$base}{init});
	%{$self->{init}} = ();
}
#==============================================================================
# <p>
#   ͼѥڡͤޤ
# </p>
# <pre>
# ->get_initdata($wiki,$label);
# </pre>
# <ul>
#   <li>$labelͤ٥Ǥ</li>
#   <li>ͤϥ٥ͤǤ</li>
#   <li>ͤundefʤ­ʤͤ¸ߤޤ</li>
# </ul>
#==============================================================================
sub get_initdata {
	my $self  = shift;
	my $wiki  = shift;
	my $label = shift;

	if($label eq ""){
		return undef;
	}
	unless($self->is_set_initpage){
		return undef;
	}

	return $self->get_data($wiki,$self->{init}{basename},"init",$label);
}
#==============================================================================
# <p>
#   ＰΥѡԤʤޤ
# </p>
# <p>
#   ĤļФＰηǤʬ䤷٥ϿХ
#   եؤ¸Ԥʤޤ㤦ϤǽλޤĤΰ
#   ͤȤ֤ޤ
# </p>
# <p>
#   Ｐˤϰʲηޤ
# </p>
# <dl>
# = <dt>٥̾==</dt>
#     <dd>٥ͤͤп</dd>
# = <dt>٥̾!=</dt>
#     <dd>٥ͤͤʤп</dd>
# = <dt>٥̾&gt;=</dt>
#     <dd>٥ͤͤ礭п</dd>
# = <dt>٥̾&lt;=</dt>
#     <dd>٥ͤͤп</dd>
#   <dt>or</dt>
#     <dd>̾and³ޤȸμor³ޤ
# 	  and³̤ͥ㤯ʤޤ</dd>
# </dl>
# <pre>
# ->set_search($wiki,$base,@param);
# </pre>
# <ul>
#   <li>$baseоݥڡΥ١̾Ǥ</li>
#   <li>@paramϥץ饰Ϥ줿ѥ᡼Ǥ</li>
#   <li>̤ͤΥѥ᡼Ǥ</li>
#   <li>­ʤ϶ΥꥹȤundef֤ޤ</li>
#   <li>ѿ{search}ϥѡ줿ＰؤΥե󥹤Ǥ</li>
# </ul>
# <dl>
#   <dt>->{search}[n][n]{label}</dt>
#     <dd>ＰΥ٥̾ʬ</dd>
#   <dt>->{search}[n][n]{op}</dt>
#     <dd>Ｐα黻ʬ</dd>
#   <dt>->{search}[n][n]{value}</dt>
#     <dd>Ｐʬ</dd>
#   <dt>->{search}[n][n]</dt>
#     <dd>Ｐɽϥåե</dd>
#   <dt>->{search}[n]</dt>
#     <dd>and³θＰΥꥹȥե</dd>
#   <dt>->{search}</dt>
#     <dd>or³Ǥ嵭Υꥹȥե</dd>
# <dl>
#==============================================================================
sub set_search {
	my $self = shift;
	my $wiki = shift;
	my $base = shift;

	if($base eq ""){
		return wantarray ? () : undef;
	}

	# ѿν
	my $parent = $self->{search} = [];

	# ΥꥹȤɲäƤ˼äƤ
	my $list = [];
	push @$parent, $list;
	while(@_){
		$_ = shift;
		if($_ eq "or"){
			# and³äΤǿꥹȤ롣
			$list = [];
			push @$parent, $list;
			next;
		}
		# ʬ䤹롣
		my ($label, $op, $value) = split(/([=!<>]=)/,$_,2);
		unless(defined $op){
			# ʬǤʤаᤷƽλ롣
			unshift @_,$_;
			last;
		}
		# Ѥ٥ͤå夵褦ˤ롣
		$self->set_label($wiki,$base,$label);
		# ä롣
		push @$list, {label=>$label, op=>$op, value=>$value};
	}
	return @_;
}
#==============================================================================
# <p>
#   ѡ줿Ｐ򸵤˳ڡޤ
# </p>
# <pre>
# ->do_search($wiki,$base);
# </pre>
# <ul>
#   <li>$baseоݥڡΥ١̾Ǥ</li>
#   <li>ͤϸ̤ΥڡֹΥꥹȤǤ</li>
#   <li>­ʤ$base١̾ˤĥڡ¸ߤʤжΥꥹ
# 	ޤundef֤ޤ</li>
#   <li>ѿ{search}ϥѡ줿ＰؤΥե󥹤Ǥ</li>
# </ul>
#==============================================================================
sub do_search {
	my $self = shift;
	my $wiki = shift;
	my $base = shift;

	if($base eq ""){
		return wantarray ? () : undef;
	}
	my @all = $self->get_number_list($wiki,$base);
	unless(@all){
		return wantarray ? () : undef;
	}

	# ޤǡ򥭥å夹롣
	$self->do_base_cache($wiki,$base);

	my %num;
	# or³ν
	foreach my $search (@{$self->{search}}){
		# ٤ƤΥڡϤ롣
		my @num = @all;
		# and³ν
		foreach my $search_item (@$search){
			# ʲ3ĤͤʤФʤʤ
			unless(
				exists $search_item->{label} and
				exists $search_item->{op}    and
				exists $search_item->{value}
			){
				return wantarray ? () : undef;
			}
			my $label = $search_item->{label};
			my $op    = $search_item->{op};
			my $value = $search_item->{value};
			# ڡʤǤ
			@num = grep {
	$op eq "==" and $value eq $self->{cache}{$base}{$_}{$label} or
	$op eq "!=" and $value ne $self->{cache}{$base}{$_}{$label} or
	$op eq "<=" and $value <= $self->{cache}{$base}{$_}{$label} or
	$op eq ">=" and $value >= $self->{cache}{$base}{$_}{$label}
			} @num;
		}
		# or³ʤΤǳڡϥåɲäƤ
		foreach(@num){
			$num{$_} = 1;
		}
	}
	@all = keys %num;
	return wantarray ? sort {$a <=> $b} @all : scalar @all;
}
#==============================================================================
# <p>
#   ȾΥѡԤʤޤ
# </p>
# <p>
#   ĤļФȾηǤʬ䤷٥ϿХ
#   եؤ¸Ԥʤޤ㤦ϤǽλޤĤΰ
#   ͤȤ֤ޤ
# </p>
# <p>
#   ʲѤǤ륽ȾǤ
# </p>
# <dl>
#   <dt>%sortby+%: %sortby_number%:</dt>
#     <dd>٥ͤͤȤƾ¤٤ޤϤ٤ƱǤ</dd>
#   <dt>%sortby-%: %sortby_number_desc%:</dt>
#     <dd>٥ͤͤȤƹ߽¤٤ޤϤ٤ƱǤ</dd>
#   <dt>%sortby&gt;%: %sortby_alphabet%:</dt>
#     <dd>٥ͤʸȤƾ¤٤ޤ¤ӤEUCɽǤ</dd>
#   <dt>%sortby&lt;%: %sortby_alphabet_desc%:</dt>
#     <dd>٥ͤʸȤƹ߽¤٤ޤ¤ӤEUCɽǤ</dd>
#   <dt>%sortby@%: %sortby_length%:</dt>
#     <dd>٥ͤĹʥХȿ˽¤٤ޤ</dd>
# </dl>
# <p>
#   Ȥ˻Ȥüʥ٥̾Ȥưʲ"%sortby+%:" "%sortby_number%:"
#   "%sortby-%:" "%sortby_number_desc%:"ǻȤޤ
# </p>
# <dl>
#   <dt>%cardform_number%</dt>
#     <dd>ڡֹ</dd>
#   <dt>%cardform_time%</dt>
#     <dd>ڡ</dd>
# </dl>
# <pre>
# ->set_sort($wiki,$base,@param);
# </pre>
# <ul>
#   <li>$baseоݥڡΥ١̾Ǥ</li>
#   <li>@paramϥץ饰Ϥ줿ѥ᡼Ǥ</li>
#   <li>̤ͤΥѥ᡼Ǥ</li>
#   <li>­ʤ϶ΥꥹȤundef֤ޤ</li>
#   <li>ѿ{sort}ϥѡ줿ȾؤΥե󥹤Ǥ</li>
# </ul>
# <dl>
#   <dt>->{sort}</dt>
#     <dd>ꥹȥե</dd>
#   <dt>->{sort}[n]</dt>
#     <dd>Ⱦɽϥåե</dd>
#   <dt>->{sort}[n]{type}</dt>
#     <dd>Ⱦμ</dd>
#   <dt>->{sort}[n]{oder}</dt>
#     <dd>Ⱦ¤</dd>
#   <dt>->{sort}[n]{label}</dt>
#     <dd>ȾΥ٥̾ʬ</dd>
# <dl>
#==============================================================================
sub set_sort {
	my $self = shift;
	my $wiki = shift;
	my $base = shift;

	if($base eq ""){
		return wantarray ? () : undef;
	}

	# ѿν
	$self->{sort} = [];

	while(@_){
		$_ = shift;
		# ʬ䤹롣ʬǤʤаᤷƽλ롣
		unless(/%sortby([^%]*)%:(.*)/){
			unshift @_,$_;
			last;
		}
		my ($op, $label) = ($1, $2);
		my ($type,$oder);
		if($op eq "+" or $op eq "_number"){
			$type = "N";
			$oder = "1";
		}elsif($op eq "-" or $op eq "_number_desc"){
			$type = "N";
			$oder = "-1";
		}elsif($op eq "<" or $op eq "_alphabet"){
			$type = "A";
			$oder = "1";
		}elsif($op eq ">" or $op eq "_alphabet_desc"){
			$type = "A";
			$oder = "-1";
		}elsif($op eq "@" or $op eq "_length"){
			$type = "L";
			$oder = "1";
		}else{
			unshift @_,$_;
			last;
		}
		# Ѥ٥ͤå夵褦ˤ롣
		unless($label =~ /%\w+%/){
			$self->set_label($wiki,$base,$label);
		}
		# ä롣
		push @{$self->{sort}}, {type=>$type,oder=>$oder,label=>$label};
	}
	return @_;
}
#==============================================================================
# <p>
#   ѡ줿Ⱦ򸵤˥ڡֹ򥽡Ȥޤ
# </p>
# <pre>
# ->do_sort($wiki,$base,@num);
# </pre>
# <ul>
#   <li>$baseоݥڡΥ١̾Ǥ</li>
#   <li>@numϥȤڡֹΥꥹȤǤ</li>
#   <li>ͤϥȤ줿ڡֹΥꥹȤǤ</li>
#   <li>­ʤжΥꥹȤ֤ޤ</li>
#   <li>ѿ{sort}ϥѡ줿ȾؤΥե󥹤Ǥ</li>
# </ul>
#==============================================================================
sub do_sort {
	my $self = shift;
	my $wiki = shift;
	my $base = shift;

	if($base eq ""){
		return ();
	}
	unless(@_){
		return ();
	}

	# ޤǡ򥭥å夹롣
	$self->do_base_cache($wiki,$base);
	my $data = $self->{cache}{$base};

	# ꤬ƤʤФΤޤ֤
	unless($self->{sort} and @{$self->{sort}}){
		return @_;
	}
	return sort {
		foreach my $sort (@{$self->{sort}}){
			# ʲ3ĤͤʤФʤʤ
			unless(
				exists $sort->{type} and
				exists $sort->{oder} and
				exists $sort->{label}
			){
				# ͤʤ̵뤷Ƽξء
				next;
			}
			my $type  = $sort->{type};
			my $oder  = $sort->{oder};
			my $label = $sort->{label};
			my $value_a;
			my $value_b;
			my $result;
			# üʥ٥ν
			if($type eq "N" and $label eq "%cardform_number%"){
				$value_a = $a;
				$value_b = $b;
			}elsif($type eq "N" and $label eq "%cardform_time%"){
				$value_a = $wiki->get_last_modified2(
						$self->num2page($base,$a));
				$value_b = $wiki->get_last_modified2(
						$self->num2page($base,$b));
			}else{
				$value_a = $data->{$a}{$label};
				$value_b = $data->{$b}{$label};
			}
			# ˡǤ
			if($type eq "N"){
				$result = $value_a <=> $value_b;
			}elsif($type eq "A"){
				$result = $value_a cmp $value_b;
			}elsif($type eq "L"){
				$result = length($value_a) <=> length($value_b);
			}
			# 羮Ф̤ˡ
			# ξǤмξˡ
			if($result){
				return $oder*$result;
			}
		}
		# ٤Ƥξ
		return 0;
	} @_;
}
#==============================================================================
# <p>
#   顼åɸinlineWIKIɬפ˱ƥС饤ɡ
# </p>
# <pre>
# ->errmsg($msg);
# </pre>
#==============================================================================
sub errmsg {
	my $self = shift;
	ref $self or unshift @_, $self;
	return Util::inline_error(shift,"WIKI");
}

1;
